//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Windows.Forms;
using System.Data;

namespace Bench
{
	/// <summary>
	/// Podsumowanie dla Form1.
	/// </summary>
	public class benchmarkForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.GroupBox sendDataGroup;
		private System.Windows.Forms.Label numberOfPacketsLabel;
		private System.Windows.Forms.Label packetSizeLabel;
		private System.Windows.Forms.Label targetServerLabel;
		private System.Windows.Forms.TextBox numberOfPackets;
		private System.Windows.Forms.TextBox packetSize;
		private System.Windows.Forms.TextBox targetServer;
		private System.Windows.Forms.GroupBox performanceStatisticsGroup;
		private System.Windows.Forms.Label bytesTransmittedLabel;
		private System.Windows.Forms.Label millisecondsElapsedLabel;
		private System.Windows.Forms.Label bytesPerSecondLabel;
		private System.Windows.Forms.TextBox bytesTransmitted;
		private System.Windows.Forms.TextBox millisecondsElapsed;
		private System.Windows.Forms.TextBox bytesPerSecond;
		private System.Windows.Forms.GroupBox testGroup;
		private System.Windows.Forms.RadioButton tcpTest;
		private System.Windows.Forms.Button startButton;
		private System.Windows.Forms.Button exitButton;
		private System.Windows.Forms.RadioButton unmanagedTcpTest;
		private System.Windows.Forms.RadioButton udpTest;
		private System.Windows.Forms.RadioButton unmanagedUdpTest;
		private System.Windows.Forms.RadioButton tcpClientTest;
		private System.Windows.Forms.RadioButton udpClientTest;
		private System.Windows.Forms.RadioButton asynchTcpTest;
		private System.Windows.Forms.TextBox networkInterfaceInstance;
		private System.Windows.Forms.Label adapterLabel;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public benchmarkForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			//
			// TODO: Dodanie kodu konstruktora po wywoaniu InitializeComponent
			//
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.asynchTcpTest = new System.Windows.Forms.RadioButton();
			this.numberOfPacketsLabel = new System.Windows.Forms.Label();
			this.targetServer = new System.Windows.Forms.TextBox();
			this.unmanagedUdpTest = new System.Windows.Forms.RadioButton();
			this.udpClientTest = new System.Windows.Forms.RadioButton();
			this.exitButton = new System.Windows.Forms.Button();
			this.tcpTest = new System.Windows.Forms.RadioButton();
			this.targetServerLabel = new System.Windows.Forms.Label();
			this.testGroup = new System.Windows.Forms.GroupBox();
			this.tcpClientTest = new System.Windows.Forms.RadioButton();
			this.udpTest = new System.Windows.Forms.RadioButton();
			this.unmanagedTcpTest = new System.Windows.Forms.RadioButton();
			this.bytesTransmittedLabel = new System.Windows.Forms.Label();
			this.numberOfPackets = new System.Windows.Forms.TextBox();
			this.bytesPerSecondLabel = new System.Windows.Forms.Label();
			this.sendDataGroup = new System.Windows.Forms.GroupBox();
			this.packetSize = new System.Windows.Forms.TextBox();
			this.packetSizeLabel = new System.Windows.Forms.Label();
			this.millisecondsElapsedLabel = new System.Windows.Forms.Label();
			this.performanceStatisticsGroup = new System.Windows.Forms.GroupBox();
			this.bytesPerSecond = new System.Windows.Forms.TextBox();
			this.millisecondsElapsed = new System.Windows.Forms.TextBox();
			this.bytesTransmitted = new System.Windows.Forms.TextBox();
			this.startButton = new System.Windows.Forms.Button();
			this.networkInterfaceInstance = new System.Windows.Forms.TextBox();
			this.adapterLabel = new System.Windows.Forms.Label();
			this.testGroup.SuspendLayout();
			this.sendDataGroup.SuspendLayout();
			this.performanceStatisticsGroup.SuspendLayout();
			this.SuspendLayout();
			// 
			// asynchTcpTest
			// 
			this.asynchTcpTest.Location = new System.Drawing.Point(112, 16);
			this.asynchTcpTest.Name = "asynchTcpTest";
			this.asynchTcpTest.TabIndex = 6;
			this.asynchTcpTest.Text = "Asynch TCP/IP";
			// 
			// numberOfPacketsLabel
			// 
			this.numberOfPacketsLabel.Location = new System.Drawing.Point(8, 16);
			this.numberOfPacketsLabel.Name = "numberOfPacketsLabel";
			this.numberOfPacketsLabel.TabIndex = 0;
			this.numberOfPacketsLabel.Text = "Liczba pakietw";
			// 
			// targetServer
			// 
			this.targetServer.Location = new System.Drawing.Point(112, 64);
			this.targetServer.Name = "targetServer";
			this.targetServer.TabIndex = 3;
			this.targetServer.Text = "localhost";
			// 
			// unmanagedUdpTest
			// 
			this.unmanagedUdpTest.Location = new System.Drawing.Point(368, 40);
			this.unmanagedUdpTest.Name = "unmanagedUdpTest";
			this.unmanagedUdpTest.Size = new System.Drawing.Size(144, 24);
			this.unmanagedUdpTest.TabIndex = 3;
			this.unmanagedUdpTest.Text = "Niezarzdzane UDP";
			// 
			// udpClientTest
			// 
			this.udpClientTest.Location = new System.Drawing.Point(8, 88);
			this.udpClientTest.Name = "udpClientTest";
			this.udpClientTest.TabIndex = 5;
			this.udpClientTest.Text = "UdpClient";
			// 
			// exitButton
			// 
			this.exitButton.Location = new System.Drawing.Point(448, 408);
			this.exitButton.Name = "exitButton";
			this.exitButton.TabIndex = 4;
			this.exitButton.Text = "Wyjd";
			this.exitButton.Click += new System.EventHandler(this.OnExit);
			// 
			// tcpTest
			// 
			this.tcpTest.Location = new System.Drawing.Point(8, 16);
			this.tcpTest.Name = "tcpTest";
			this.tcpTest.TabIndex = 0;
			this.tcpTest.Text = "TCP/IP";
			// 
			// targetServerLabel
			// 
			this.targetServerLabel.Location = new System.Drawing.Point(8, 64);
			this.targetServerLabel.Name = "targetServerLabel";
			this.targetServerLabel.TabIndex = 2;
			this.targetServerLabel.Text = "Serwer docelowy";
			// 
			// testGroup
			// 
			this.testGroup.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.asynchTcpTest,
																					this.udpClientTest,
																					this.tcpClientTest,
																					this.unmanagedUdpTest,
																					this.udpTest,
																					this.unmanagedTcpTest,
																					this.tcpTest});
			this.testGroup.Location = new System.Drawing.Point(8, 144);
			this.testGroup.Name = "testGroup";
			this.testGroup.Size = new System.Drawing.Size(536, 152);
			this.testGroup.TabIndex = 2;
			this.testGroup.TabStop = false;
			// 
			// tcpClientTest
			// 
			this.tcpClientTest.Location = new System.Drawing.Point(8, 64);
			this.tcpClientTest.Name = "tcpClientTest";
			this.tcpClientTest.TabIndex = 4;
			this.tcpClientTest.Text = "TcpClient";
			// 
			// udpTest
			// 
			this.udpTest.Location = new System.Drawing.Point(8, 40);
			this.udpTest.Name = "udpTest";
			this.udpTest.TabIndex = 2;
			this.udpTest.Text = "UDP";
			// 
			// unmanagedTcpTest
			// 
			this.unmanagedTcpTest.Location = new System.Drawing.Point(368, 16);
			this.unmanagedTcpTest.Name = "unmanagedTcpTest";
			this.unmanagedTcpTest.Size = new System.Drawing.Size(144, 24);
			this.unmanagedTcpTest.TabIndex = 1;
			this.unmanagedTcpTest.Text = "Niezarzdzane TCP/IP";
			// 
			// bytesTransmittedLabel
			// 
			this.bytesTransmittedLabel.Location = new System.Drawing.Point(8, 16);
			this.bytesTransmittedLabel.Name = "bytesTransmittedLabel";
			this.bytesTransmittedLabel.Size = new System.Drawing.Size(112, 23);
			this.bytesTransmittedLabel.TabIndex = 0;
			this.bytesTransmittedLabel.Text = "Przesane bajty";
			// 
			// numberOfPackets
			// 
			this.numberOfPackets.Location = new System.Drawing.Point(112, 16);
			this.numberOfPackets.Name = "numberOfPackets";
			this.numberOfPackets.TabIndex = 3;
			this.numberOfPackets.Text = "100";
			// 
			// bytesPerSecondLabel
			// 
			this.bytesPerSecondLabel.Location = new System.Drawing.Point(8, 64);
			this.bytesPerSecondLabel.Name = "bytesPerSecondLabel";
			this.bytesPerSecondLabel.Size = new System.Drawing.Size(112, 23);
			this.bytesPerSecondLabel.TabIndex = 2;
			this.bytesPerSecondLabel.Text = "Bajty/sekund";
			// 
			// sendDataGroup
			// 
			this.sendDataGroup.Controls.AddRange(new System.Windows.Forms.Control[] {
																						this.targetServer,
																						this.packetSize,
																						this.numberOfPackets,
																						this.targetServerLabel,
																						this.packetSizeLabel,
																						this.numberOfPacketsLabel});
			this.sendDataGroup.Location = new System.Drawing.Point(8, 8);
			this.sendDataGroup.Name = "sendDataGroup";
			this.sendDataGroup.Size = new System.Drawing.Size(224, 128);
			this.sendDataGroup.TabIndex = 0;
			this.sendDataGroup.TabStop = false;
			this.sendDataGroup.Text = "Wylij dane";
			// 
			// packetSize
			// 
			this.packetSize.Location = new System.Drawing.Point(112, 40);
			this.packetSize.Name = "packetSize";
			this.packetSize.TabIndex = 3;
			this.packetSize.Text = "16384";
			// 
			// packetSizeLabel
			// 
			this.packetSizeLabel.Location = new System.Drawing.Point(8, 40);
			this.packetSizeLabel.Name = "packetSizeLabel";
			this.packetSizeLabel.TabIndex = 1;
			this.packetSizeLabel.Text = "Wielko pakietu";
			// 
			// millisecondsElapsedLabel
			// 
			this.millisecondsElapsedLabel.Location = new System.Drawing.Point(8, 40);
			this.millisecondsElapsedLabel.Name = "millisecondsElapsedLabel";
			this.millisecondsElapsedLabel.Size = new System.Drawing.Size(112, 23);
			this.millisecondsElapsedLabel.TabIndex = 1;
			this.millisecondsElapsedLabel.Text = "Czas w sekundach";
			// 
			// performanceStatisticsGroup
			// 
			this.performanceStatisticsGroup.Controls.AddRange(new System.Windows.Forms.Control[] {
																									 this.adapterLabel,
																									 this.networkInterfaceInstance,
																									 this.bytesPerSecond,
																									 this.millisecondsElapsed,
																									 this.bytesTransmitted,
																									 this.bytesPerSecondLabel,
																									 this.millisecondsElapsedLabel,
																									 this.bytesTransmittedLabel});
			this.performanceStatisticsGroup.Location = new System.Drawing.Point(256, 8);
			this.performanceStatisticsGroup.Name = "performanceStatisticsGroup";
			this.performanceStatisticsGroup.Size = new System.Drawing.Size(288, 128);
			this.performanceStatisticsGroup.TabIndex = 1;
			this.performanceStatisticsGroup.TabStop = false;
			this.performanceStatisticsGroup.Text = "Statystyki wydajnoci";
			// 
			// bytesPerSecond
			// 
			this.bytesPerSecond.Location = new System.Drawing.Point(120, 64);
			this.bytesPerSecond.Name = "bytesPerSecond";
			this.bytesPerSecond.ReadOnly = true;
			this.bytesPerSecond.Size = new System.Drawing.Size(160, 20);
			this.bytesPerSecond.TabIndex = 5;
			this.bytesPerSecond.Text = "";
			// 
			// millisecondsElapsed
			// 
			this.millisecondsElapsed.Location = new System.Drawing.Point(120, 40);
			this.millisecondsElapsed.Name = "millisecondsElapsed";
			this.millisecondsElapsed.ReadOnly = true;
			this.millisecondsElapsed.Size = new System.Drawing.Size(160, 20);
			this.millisecondsElapsed.TabIndex = 4;
			this.millisecondsElapsed.Text = "";
			// 
			// bytesTransmitted
			// 
			this.bytesTransmitted.Location = new System.Drawing.Point(120, 16);
			this.bytesTransmitted.Name = "bytesTransmitted";
			this.bytesTransmitted.ReadOnly = true;
			this.bytesTransmitted.Size = new System.Drawing.Size(160, 20);
			this.bytesTransmitted.TabIndex = 3;
			this.bytesTransmitted.Text = "";
			// 
			// startButton
			// 
			this.startButton.Location = new System.Drawing.Point(16, 408);
			this.startButton.Name = "startButton";
			this.startButton.TabIndex = 3;
			this.startButton.Text = "Start";
			this.startButton.Click += new System.EventHandler(this.OnStart);
			// 
			// networkInterfaceInstance
			// 
			this.networkInterfaceInstance.Location = new System.Drawing.Point(120, 88);
			this.networkInterfaceInstance.Name = "networkInterfaceInstance";
			this.networkInterfaceInstance.ReadOnly = true;
			this.networkInterfaceInstance.Size = new System.Drawing.Size(160, 20);
			this.networkInterfaceInstance.TabIndex = 5;
			this.networkInterfaceInstance.Text = "";
			// 
			// adapterLabel
			// 
			this.adapterLabel.Location = new System.Drawing.Point(8, 88);
			this.adapterLabel.Name = "adapterLabel";
			this.adapterLabel.Size = new System.Drawing.Size(112, 23);
			this.adapterLabel.TabIndex = 2;
			this.adapterLabel.Text = "Karta sieciowa";
			// 
			// benchmarkForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(552, 445);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.exitButton,
																		  this.startButton,
																		  this.testGroup,
																		  this.performanceStatisticsGroup,
																		  this.sendDataGroup});
			this.Name = "benchmarkForm";
			this.Text = "Testy wydajnosi sieci .NET";
			this.testGroup.ResumeLayout(false);
			this.sendDataGroup.ResumeLayout(false);
			this.performanceStatisticsGroup.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new benchmarkForm());
		}

		private void OnStart(object sender, System.EventArgs e)
		{
			NetworkTest test;
			int n = Convert.ToInt32(numberOfPackets.Text);
			int s = Convert.ToInt32(packetSize.Text);
			string server = targetServer.Text;
			if(tcpTest.Checked)
			{
				// Echo na porcie 7
				test = new TcpTest(server, 7, n, s);
			}
			else if(unmanagedTcpTest.Checked)
			{
				// Echo na porcie 7
				test = new UnmanagedTcpTest(server, 7, n, s);
			}
			else if(udpTest.Checked)
			{
				int fs = Convert.ToInt32(s);
				if(fs > 8192)
					fs = 8192;
				test = new UdpTest(server, 7, n, fs);
			}
			else if(unmanagedUdpTest.Checked)
			{
				int fs = Convert.ToInt32(s);
				if(fs > 8192)
					fs = 8192;
				test = new UnmanagedUdpTest(server, 7, n, fs);
			}
			else if(tcpClientTest.Checked)
			{
				test = new TcpClientTest(server, 7, n, s);
			}
			else if(udpClientTest.Checked)
			{
				int fs = Convert.ToInt32(s);
				if(fs > 8192)
					fs = 8192;
				test = new UdpClientTest(server, 7, n, fs);
			}
			else if(asynchTcpTest.Checked)
			{
				test = new AsynchTcpTest(server, 7, n, s);
			}
			else
			{
				throw new ArgumentOutOfRangeException("RadioButton", "Naley zaznaczy co najmniej jedn z opcji testu");
			}

			millisecondsElapsed.Clear();
			millisecondsElapsed.Refresh();
			bytesTransmitted.Clear();
			bytesTransmitted.Refresh();
			bytesPerSecond.Clear();
			bytesPerSecond.Refresh();
			networkInterfaceInstance.Clear();
			networkInterfaceInstance.Refresh();

			test.Start();

			float [] rate = test.Rate;
			string [] names = test.InstanceNames;

			millisecondsElapsed.Text = Convert.ToString(test.Elapsed/1000.0F);
			bytesTransmitted.Text = Convert.ToString(test.ReceivedByteCount + test.TransmitByteCount) +
                                    " (" +
									Convert.ToString(test.NumberOfPackets * test.PacketSize * 2) +
			                        ")";
			int maxRateIndex = 0;
			for(int i = 0; i < rate.Length; i++)
			{
				if(rate[i] > rate[maxRateIndex])
					maxRateIndex = i;
			}
			bytesPerSecond.Text = Convert.ToString(rate[maxRateIndex]) +
				                  " (" +
				                  Convert.ToString((test.NumberOfPackets * test.PacketSize * 2)/(test.Elapsed / 1000)) +
				                  ")";
			networkInterfaceInstance.Text = names[maxRateIndex];
		}

		private void OnExit(object sender, System.EventArgs e)
		{
			// Wyjcie z aplikacji
			Application.Exit();
		}
	}
}
